import math

def solve():
    n = int(input())
    x = list(map(int, input().split()))
    h = list(map(int, input().split()))

    poles = sorted(zip(x, h))

    ropes = []
    for i in range(n - 1):
        x1, h1 = poles[i]
        x2, h2 = poles[i + 1]

        xp = (h1 + h2 + x1 + x2) / 2
        yp = h1 - (xp - x1)

        ropes.append((x1, h1, xp, yp, x2, h2))

    for i in range(n):
        xi, hi = poles[i]
        best = float("inf")

        for j in range(n):
            if i == j:
                continue
            xj, hj = poles[j]
            if hj >= hi:
                dist = math.hypot(xj - xi, hj - hi)
                best = min(best, dist)

        for (x1, h1, xp, yp, x2, h2) in ropes:

            left = max(x1, xi - (hi - h1))
            right = min(xp, xi + (hi - h1))
            if left <= right:
                xq = min(max(xi, left), right)
                yq = h1 - (xq - x1)
                if yq >= hi:
                    best = min(best, math.hypot(xq - xi, yq - hi))

            left = max(xp, xi - (h2 - hi))
            right = min(x2, xi + (h2 - hi))
            if left <= right:
                xq = min(max(xi, left), right)
                yq = h2 - (x2 - xq)
                if yq >= hi:
                    best = min(best, math.hypot(xq - xi, yq - hi))

        if best == float("inf"):
            print(-1)
        else:
            print(int(best))


solve()